package nl.ivojonker.icn.configuration;

import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import com.ibm.ecm.extension.*;
import com.ibm.ecm.extension.PluginAction;
import com.ibm.ecm.extension.PluginFeature;
import com.ibm.ecm.extension.PluginLayout;
import com.ibm.ecm.extension.PluginMenu;
import com.ibm.ecm.extension.PluginMenuType;
import com.ibm.ecm.extension.PluginODAuthenticationService;
import com.ibm.ecm.extension.PluginOpenAction;
import com.ibm.ecm.extension.PluginRequestFilter;
import com.ibm.ecm.extension.PluginResponseFilter;
import com.ibm.ecm.extension.PluginService;
import com.ibm.ecm.extension.PluginServiceCallbacks;
import com.ibm.ecm.extension.PluginViewerDef;

/**
 * This plugin offers a convenient interface (through java or dojo/js) to a 'Central Configuration' that basically 
 * consists of key's and values.
 * 
 * The configuration can only be manipulated via the ICN's admin desktop->plugin configuration page.
 * 
 * @author nl.ivojonker
 */
public class CentralConfigurationPlugin extends Plugin {

	private static final String pluginVersion = "1.0.0";
	private static final String pluginUpdateChecker = " <img style='cursor:pointer' onclick='window.open(\"http://www.ivojonker.nl/?page_id=409\")' width='18px' height='18px' src='ecm/themes/oneui/idx/oneui/messaging/images/msgInfo48.png' onload='var triggerEl=event.srcElement,currentVersion=triggerEl.parentElement.innerText;require([\"dojo/_base/xhr\"],function(a){a(\"GET\",{url:\"http://ivojonker.nl/ivo/wp-attachments/CentralConfigurationPluginVersionChecker.php?currentVersion=\"+currentVersion.trim(),load:function(a){var b=document.createElement(\"span\");b.innerHTML=a,triggerEl.parentElement.appendChild(b)},error:function(){}},!1)});' />&nbsp;";
	
	/**
	 * {@inheritDoc}
	 */
	public void applicationInit(HttpServletRequest request,
			PluginServiceCallbacks callbacks) throws Exception {
	}

	/**
	 * {@inheritDoc}
	 */
	public String getId() {
		return "CentralConfigurationPlugin";
	}

	/**
	 * {@inheritDoc}
	 */
	public String getName(Locale locale) {
		return "Central Configuration Repository";
	}

	/**
	 * {@inheritDoc}
	 */
	public String getVersion() {
		return pluginVersion+pluginUpdateChecker;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getCopyright() {
		return "MIT Licensed; Copyright (c) 2016 Ivo Jonker (ivojonker.nl)";
	}

	/**
	 * {@inheritDoc}
	 */
	public String getScript() {
		return "CentralConfigurationPlugin.js";
	}

	/**
	 * {@inheritDoc}
	 */
	public String getDebugScript() {
		return getScript();
	}

	/**
	 * {@inheritDoc}
	 */
	public String getDojoModule() {
		return "centralConfigurationPluginDojo";
	}

	/**
	 * {@inheritDoc}
	 */
	public String getCSSFileName() {
		return "CentralConfigurationPlugin.css";
	}

	/**
	 * {@inheritDoc}
	 */
	public String getDebugCSSFileName() {
		return getCSSFileName();
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginAction[] getActions() {
		return new PluginAction[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginOpenAction[] getOpenActions() {
		return new PluginOpenAction[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginRequestFilter[] getRequestFilters() {
		return new PluginRequestFilter[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginODAuthenticationService getODAuthenticationService() {
		return null;
	}

	/**
	 * {@inheritDoc}
	 */
	public String getConfigurationDijitClass() {
		return "centralConfigurationPluginDojo.ConfigurationPane";
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginViewerDef[] getViewers() {
		return new PluginViewerDef[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginLayout[] getLayouts() {
		return new PluginLayout[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginFeature[] getFeatures() {
		return new PluginFeature[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginMenuType[] getMenuTypes() {
		return new PluginMenuType[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public PluginMenu[] getMenus() {
		return new PluginMenu[0];
	}

	/**
	 * {@inheritDoc}
	 */
	public com.ibm.ecm.extension.PluginService[] getServices() {
		return new com.ibm.ecm.extension.PluginService[]{new nl.ivojonker.icn.configuration.services.ConfigurationService()};
	}

	/**
	 * {@inheritDoc}
	 */
	public com.ibm.ecm.extension.PluginResponseFilter[] getResponseFilters() {
		return new com.ibm.ecm.extension.PluginResponseFilter[]{};
	}
	
}
